unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Borland.Eco.UmlRt,
    Borland.Eco.ObjectRepresentation,
  Borland.Eco.WinForm, Borland.Eco.Handles, BldOwnEcoSpace, CoreClassesUnit;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    EcoGlobalActions: Borland.Eco.WinForm.EcoActionExtender;
    EcoAutoForms: Borland.Eco.WinForm.EcoAutoFormExtender;
    EcoListActions: Borland.Eco.WinForm.EcoListActionExtender;
    EcoModelAwareDragDrop: Borland.Eco.WinForm.EcoDragDropExtender;
    ehAllPersons: Borland.Eco.Handles.ExpressionHandle;
    dgAllPersons: System.Windows.Forms.DataGrid;
    cmAllPersons: Borland.Eco.Handles.CurrencyManagerHandle;
    Button1: System.Windows.Forms.Button;
    btnDeletePerson: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    Button4: System.Windows.Forms.Button;
    Button5: System.Windows.Forms.Button;
    Button6: System.Windows.Forms.Button;
    ehAllBuildings: Borland.Eco.Handles.ExpressionHandle;
    dgAllBuildings: System.Windows.Forms.DataGrid;
    cmAllBuildings: Borland.Eco.Handles.CurrencyManagerHandle;
    btnNextBuilding: System.Windows.Forms.Button;
    btnLastBuilding: System.Windows.Forms.Button;
    btnAddBuilding: System.Windows.Forms.Button;
    btnDeleteBuilding: System.Windows.Forms.Button;
    btnFirstBuilding: System.Windows.Forms.Button;
    btnPrevBuilding: System.Windows.Forms.Button;
    DataGridTableStyle2: System.Windows.Forms.DataGridTableStyle;
    DataGridTextBoxColumn3: System.Windows.Forms.DataGridTextBoxColumn;
    DataGridTextBoxColumn4: System.Windows.Forms.DataGridTextBoxColumn;
    lbxOwnedBuildings: System.Windows.Forms.ListBox;
    ehOwnedbuildings: Borland.Eco.Handles.ExpressionHandle;
    btnPayRent: System.Windows.Forms.Button;
    btnAddRB: System.Windows.Forms.Button;
    lbxOwners: System.Windows.Forms.ListBox;
    ehOwners: Borland.Eco.Handles.ExpressionHandle;
    TextBox1: System.Windows.Forms.TextBox;
    ehHome: Borland.Eco.Handles.ExpressionHandle;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    GroupBox1: System.Windows.Forms.GroupBox;
    GroupBox2: System.Windows.Forms.GroupBox;
    Button13: System.Windows.Forms.Button;
    Label3: System.Windows.Forms.Label;
    btnUnlink: System.Windows.Forms.Button;
    GroupBox3: System.Windows.Forms.GroupBox;
    btnActivate: System.Windows.Forms.Button;
    btnUpdateDB: System.Windows.Forms.Button;
    btnCreateSchema: System.Windows.Forms.Button;
    btnCheckpoint: System.Windows.Forms.Button;
    btnUndo: System.Windows.Forms.Button;
    btnRedo: System.Windows.Forms.Button;
    TabControl1: System.Windows.Forms.TabControl;
    TabPage1: System.Windows.Forms.TabPage;
    TabPage2: System.Windows.Forms.TabPage;
    ehResidentialBuildings: Borland.Eco.Handles.ExpressionHandle;
    dgResidentialBuilding: System.Windows.Forms.DataGrid;
    btnAddResidentialBuilding: System.Windows.Forms.Button;
    lbxResidents: System.Windows.Forms.ListBox;
    Label4: System.Windows.Forms.Label;
    ehResidents: Borland.Eco.Handles.ExpressionHandle;
    btnFirstRB: System.Windows.Forms.Button;
    btnPrevRB: System.Windows.Forms.Button;
    btnNextRB: System.Windows.Forms.Button;
    btnLastRB: System.Windows.Forms.Button;
    btnLeave: System.Windows.Forms.Button;
    btnChargeRent: System.Windows.Forms.Button;
    cmResidentialBuildings: Borland.Eco.Handles.CurrencyManagerHandle;
    cmnOwnedBldg: System.Windows.Forms.ContextMenu;
    MenuItem1: System.Windows.Forms.MenuItem;
    cmnResBuild: System.Windows.Forms.ContextMenu;
    MenuItem2: System.Windows.Forms.MenuItem;
    cmnPerson: System.Windows.Forms.ContextMenu;
    MenuItem3: System.Windows.Forms.MenuItem;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents ofecospace this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnPayRent_Click(sender: System.Object; e: System.EventArgs);
    procedure btnAddRB_Click(sender: System.Object; e: System.EventArgs);
    procedure TextBox1_DragDrop(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
    procedure TextBox1_DragOver(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
    procedure TextBox1_DragEnter(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
    procedure btnLeave_Click(sender: System.Object; e: System.EventArgs);
    procedure Button25_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    FEcoSpace: TBldOwnEcoSpace;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    function GetDraggedObject(e: System.Windows.Forms.DragEventArgs): IObject;
  public
    constructor Create;
    property EcoSpace: TBldOwnEcoSpace read FEcoSpace;
  end;

implementation

uses
  System.Globalization;

procedure TWinForm.Button25_Click(sender: System.Object; e: System.EventArgs);
var
  rb: ResidentialBuilding;
begin
  try
    //rb := IElementProvider(dgResidentialBuilding.BindingContext[dgResidentialBuilding.DataSource].Current).Element.AsObject as ResidentialBuilding;
    rb := (CurrencyManagerHandle.CurrentElement(dgResidentialBuilding) as IObject).AsObject as ResidentialBuilding;
    rb.ChargeRent;
  except
    on e:Exception do
      MessageBox.Show(e.Message);
  end;
end;

procedure TWinForm.btnLeave_Click(sender: System.Object; e: System.EventArgs);
var
  p: Person;
begin
  p := (cmAllPersons.Element.AsObject as Person);
  if Assigned(p) then
    p.Home := nil;
end;

procedure TWinForm.TextBox1_DragEnter(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
var
  o: IObject;
begin
  o := GetDraggedObject(e);
  if (o.AsObject is ResidentialBuilding) then
    e.Effect := DragDropEffects.Link;
end;

procedure TWinForm.TextBox1_DragOver(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
var
  o: IObject;
begin
  o := GetDraggedObject(e);
  if (o.AsObject is ResidentialBuilding) then
    e.Effect := DragDropEffects.Link;
end;

procedure TWinForm.TextBox1_DragDrop(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
var
  o: IObject;
begin
  o := GetDraggedObject(e);
  if (o.AsObject is ResidentialBuilding) and (Assigned(cmAllPersons.Element)) then
    (cmAllPersons.Element.AsObject as Person).Home := o.AsObject as ResidentialBuilding;
end;

procedure TWinForm.btnAddRB_Click(sender: System.Object; e: System.EventArgs);
begin
  ResidentialBuilding.Create(EcoSpace);
end;

procedure TWinForm.btnPayRent_Click(sender: System.Object; e: System.EventArgs);
var
  p: Person;
begin
  try
    p := (cmAllPersons.Element.AsObject as Person);
    p.Payrent;
  except
    on e:Exception do
      MessageBox.Show(e.Message);
  end;
end;

{$REGION 'Windows Form Designer generated code'}
procedure TWinForm.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_DataGridTableStyle = array of System.Windows.Forms.DataGridTableStyle;
  TArrayOfSystem_Windows_Forms_DataGridColumnStyle = array of System.Windows.Forms.DataGridColumnStyle;
  TArrayOfSystem_Windows_Forms_MenuItem = array of System.Windows.Forms.MenuItem;
begin
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.EcoGlobalActions := Borland.Eco.WinForm.EcoActionExtender.Create;
  Self.btnActivate := System.Windows.Forms.Button.Create;
  Self.btnCreateSchema := System.Windows.Forms.Button.Create;
  Self.btnCheckpoint := System.Windows.Forms.Button.Create;
  Self.btnUndo := System.Windows.Forms.Button.Create;
  Self.btnRedo := System.Windows.Forms.Button.Create;
  Self.btnUpdateDB := System.Windows.Forms.Button.Create;
  Self.EcoAutoForms := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.dgAllBuildings := System.Windows.Forms.DataGrid.Create;
  Self.ehAllBuildings := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.DataGridTableStyle2 := System.Windows.Forms.DataGridTableStyle.Create;
  Self.DataGridTextBoxColumn3 := System.Windows.Forms.DataGridTextBoxColumn.Create;
  Self.DataGridTextBoxColumn4 := System.Windows.Forms.DataGridTextBoxColumn.Create;
  Self.dgAllPersons := System.Windows.Forms.DataGrid.Create;
  Self.ehAllPersons := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.dgResidentialBuilding := System.Windows.Forms.DataGrid.Create;
  Self.cmnResBuild := System.Windows.Forms.ContextMenu.Create;
  Self.MenuItem2 := System.Windows.Forms.MenuItem.Create;
  Self.ehResidentialBuildings := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.EcoListActions := Borland.Eco.WinForm.EcoListActionExtender.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.btnDeletePerson := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.Button4 := System.Windows.Forms.Button.Create;
  Self.Button5 := System.Windows.Forms.Button.Create;
  Self.Button6 := System.Windows.Forms.Button.Create;
  Self.btnNextBuilding := System.Windows.Forms.Button.Create;
  Self.cmAllBuildings := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.btnLastBuilding := System.Windows.Forms.Button.Create;
  Self.btnAddBuilding := System.Windows.Forms.Button.Create;
  Self.btnDeleteBuilding := System.Windows.Forms.Button.Create;
  Self.btnFirstBuilding := System.Windows.Forms.Button.Create;
  Self.btnPrevBuilding := System.Windows.Forms.Button.Create;
  Self.Button13 := System.Windows.Forms.Button.Create;
  Self.lbxOwnedBuildings := System.Windows.Forms.ListBox.Create;
  Self.cmnOwnedBldg := System.Windows.Forms.ContextMenu.Create;
  Self.MenuItem1 := System.Windows.Forms.MenuItem.Create;
  Self.ehOwnedbuildings := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.cmAllPersons := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.btnUnlink := System.Windows.Forms.Button.Create;
  Self.lbxOwners := System.Windows.Forms.ListBox.Create;
  Self.ehOwners := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.btnAddResidentialBuilding := System.Windows.Forms.Button.Create;
  Self.btnFirstRB := System.Windows.Forms.Button.Create;
  Self.btnPrevRB := System.Windows.Forms.Button.Create;
  Self.btnNextRB := System.Windows.Forms.Button.Create;
  Self.btnLastRB := System.Windows.Forms.Button.Create;
  Self.MenuItem3 := System.Windows.Forms.MenuItem.Create;
  Self.EcoModelAwareDragDrop := Borland.Eco.WinForm.EcoDragDropExtender.Create;
  Self.lbxResidents := System.Windows.Forms.ListBox.Create;
  Self.ehResidents := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.cmResidentialBuildings := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.btnPayRent := System.Windows.Forms.Button.Create;
  Self.btnAddRB := System.Windows.Forms.Button.Create;
  Self.ehHome := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.TabControl1 := System.Windows.Forms.TabControl.Create;
  Self.TabPage1 := System.Windows.Forms.TabPage.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.TabPage2 := System.Windows.Forms.TabPage.Create;
  Self.btnChargeRent := System.Windows.Forms.Button.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.GroupBox2 := System.Windows.Forms.GroupBox.Create;
  Self.btnLeave := System.Windows.Forms.Button.Create;
  Self.GroupBox3 := System.Windows.Forms.GroupBox.Create;
  Self.cmnPerson := System.Windows.Forms.ContextMenu.Create;
  (System.ComponentModel.ISupportInitialize(Self.dgAllBuildings)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgAllPersons)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgResidentialBuilding)).BeginInit;
  Self.GroupBox1.SuspendLayout;
  Self.TabControl1.SuspendLayout;
  Self.TabPage1.SuspendLayout;
  Self.TabPage2.SuspendLayout;
  Self.GroupBox2.SuspendLayout;
  Self.GroupBox3.SuspendLayout;
  Self.SuspendLayout;
  // 
  // EcoGlobalActions
  // 
  Self.EcoGlobalActions.RootHandle := Self.rhRoot;
  // 
  // btnActivate
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnActivate, Borland.Eco.WinForm.EcoAction.ToggleActive);
  Self.btnActivate.Location := System.Drawing.Point.Create(8, 24);
  Self.btnActivate.Name := 'btnActivate';
  Self.btnActivate.Size := System.Drawing.Size.Create(96, 23);
  Self.btnActivate.TabIndex := 0;
  Self.btnActivate.Text := 'Activate';
  // 
  // btnCreateSchema
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnCreateSchema, Borland.Eco.WinForm.EcoAction.CreateSchema);
  Self.btnCreateSchema.Location := System.Drawing.Point.Create(8, 88);
  Self.btnCreateSchema.Name := 'btnCreateSchema';
  Self.btnCreateSchema.Size := System.Drawing.Size.Create(96, 23);
  Self.btnCreateSchema.TabIndex := 2;
  Self.btnCreateSchema.Text := 'Create Schema';
  // 
  // btnCheckpoint
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnCheckpoint, Borland.Eco.WinForm.EcoAction.SetCheckPoint);
  Self.btnCheckpoint.Location := System.Drawing.Point.Create(8, 136);
  Self.btnCheckpoint.Name := 'btnCheckpoint';
  Self.btnCheckpoint.Size := System.Drawing.Size.Create(96, 23);
  Self.btnCheckpoint.TabIndex := 3;
  Self.btnCheckpoint.Text := 'Set Checkpoint';
  // 
  // btnUndo
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnUndo, Borland.Eco.WinForm.EcoAction.Undo);
  Self.btnUndo.Location := System.Drawing.Point.Create(8, 160);
  Self.btnUndo.Name := 'btnUndo';
  Self.btnUndo.Size := System.Drawing.Size.Create(96, 23);
  Self.btnUndo.TabIndex := 4;
  Self.btnUndo.Text := 'Undo';
  // 
  // btnRedo
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnRedo, Borland.Eco.WinForm.EcoAction.Redo);
  Self.btnRedo.Location := System.Drawing.Point.Create(8, 184);
  Self.btnRedo.Name := 'btnRedo';
  Self.btnRedo.Size := System.Drawing.Size.Create(96, 23);
  Self.btnRedo.TabIndex := 5;
  Self.btnRedo.Text := 'Redo';
  // 
  // btnUpdateDB
  // 
  Self.EcoGlobalActions.SetEcoAction(Self.btnUpdateDB, Borland.Eco.WinForm.EcoAction.UpdateDatabase);
  Self.btnUpdateDB.Location := System.Drawing.Point.Create(8, 64);
  Self.btnUpdateDB.Name := 'btnUpdateDB';
  Self.btnUpdateDB.Size := System.Drawing.Size.Create(96, 23);
  Self.btnUpdateDB.TabIndex := 1;
  Self.btnUpdateDB.Text := 'Update DB';
  // 
  // dgAllBuildings
  // 
  Self.dgAllBuildings.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.dgAllBuildings.CaptionText := 'Buildings';
  Self.dgAllBuildings.DataMember := '';
  Self.dgAllBuildings.DataSource := Self.ehAllBuildings;
  Self.EcoAutoForms.SetEcoAutoForm(Self.dgAllBuildings, True);
  Self.EcoModelAwareDragDrop.SetEcoDragSource(Self.dgAllBuildings, True);
  Self.dgAllBuildings.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgAllBuildings.Location := System.Drawing.Point.Create(8, 8);
  Self.dgAllBuildings.Name := 'dgAllBuildings';
  Self.dgAllBuildings.Size := System.Drawing.Size.Create(416, 176);
  Self.dgAllBuildings.TabIndex := 7;
  Self.dgAllBuildings.TableStyles.AddRange(TArrayOfSystem_Windows_Forms_DataGridTableStyle.Create(Self.DataGridTableStyle2));
  // 
  // ehAllBuildings
  // 
  Self.ehAllBuildings.Expression := 'Building.allInstances';
  Self.ehAllBuildings.RootHandle := Self.rhRoot;
  // 
  // DataGridTableStyle2
  // 
  Self.DataGridTableStyle2.DataGrid := Self.dgAllBuildings;
  Self.DataGridTableStyle2.GridColumnStyles.AddRange(TArrayOfSystem_Windows_Forms_DataGridColumnStyle.Create(Self.DataGridTextBoxColumn3, 
          Self.DataGridTextBoxColumn4));
  Self.DataGridTableStyle2.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGridTableStyle2.MappingName := '';
  // 
  // DataGridTextBoxColumn3
  // 
  Self.DataGridTextBoxColumn3.Format := '';
  Self.DataGridTextBoxColumn3.FormatInfo := nil;
  Self.DataGridTextBoxColumn3.HeaderText := 'Address';
  Self.DataGridTextBoxColumn3.MappingName := 'Address';
  Self.DataGridTextBoxColumn3.Width := 75;
  // 
  // DataGridTextBoxColumn4
  // 
  Self.DataGridTextBoxColumn4.Format := '';
  Self.DataGridTextBoxColumn4.FormatInfo := nil;
  Self.DataGridTextBoxColumn4.HeaderText := 'Tax.Value';
  Self.DataGridTextBoxColumn4.MappingName := 'taxValue';
  Self.DataGridTextBoxColumn4.Width := 75;
  // 
  // dgAllPersons
  // 
  Self.dgAllPersons.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.dgAllPersons.CaptionText := 'Persons';
  Self.dgAllPersons.ContextMenu := Self.cmnPerson;
  Self.dgAllPersons.DataMember := '';
  Self.dgAllPersons.DataSource := Self.ehAllPersons;
  Self.EcoAutoForms.SetEcoAutoForm(Self.dgAllPersons, True);
  Self.EcoModelAwareDragDrop.SetEcoDragSource(Self.dgAllPersons, True);
  Self.dgAllPersons.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgAllPersons.Location := System.Drawing.Point.Create(8, 16);
  Self.dgAllPersons.Name := 'dgAllPersons';
  Self.dgAllPersons.Size := System.Drawing.Size.Create(400, 208);
  Self.dgAllPersons.TabIndex := 0;
  // 
  // ehAllPersons
  // 
  Self.ehAllPersons.Expression := 'Person.allInstances';
  Self.ehAllPersons.RootHandle := Self.rhRoot;
  // 
  // dgResidentialBuilding
  // 
  Self.dgResidentialBuilding.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.dgResidentialBuilding.ContextMenu := Self.cmnResBuild;
  Self.dgResidentialBuilding.DataMember := '';
  Self.dgResidentialBuilding.DataSource := Self.ehResidentialBuildings;
  Self.EcoAutoForms.SetEcoAutoForm(Self.dgResidentialBuilding, True);
  Self.EcoModelAwareDragDrop.SetEcoDragSource(Self.dgResidentialBuilding, True);
  Self.dgResidentialBuilding.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgResidentialBuilding.Location := System.Drawing.Point.Create(8, 8);
  Self.dgResidentialBuilding.Name := 'dgResidentialBuilding';
  Self.dgResidentialBuilding.Size := System.Drawing.Size.Create(504, 176);
  Self.dgResidentialBuilding.TabIndex := 0;
  // 
  // cmnResBuild
  // 
  Self.cmnResBuild.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.MenuItem2));
  // 
  // MenuItem2
  // 
  Self.EcoListActions.SetActionExpression(Self.MenuItem2, 'self.ChargeRent');
  Self.EcoListActions.SetBindingContext(Self.MenuItem2, Self.dgResidentialBuilding);
  Self.EcoListActions.SetEcoListAction(Self.MenuItem2, Borland.Eco.WinForm.ListAction.ExecuteAction);
  Self.MenuItem2.Index := 0;
  Self.EcoListActions.SetRootHandle(Self.MenuItem2, Self.ehResidentialBuildings);
  Self.MenuItem2.Text := 'Charge Rent';
  // 
  // ehResidentialBuildings
  // 
  Self.ehResidentialBuildings.Expression := 'ResidentialBuilding.allInstance' +
  's';
  Self.ehResidentialBuildings.RootHandle := Self.rhRoot;
  // 
  // EcoListActions
  // 
  Self.EcoListActions.CaptionMoveFirst := '|<';
  Self.EcoListActions.CaptionMoveLast := '>|';
  Self.EcoListActions.CaptionMoveNext := '>';
  Self.EcoListActions.CaptionMovePrev := '<';
  // 
  // Button1
  // 
  Self.Button1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.Button1, Borland.Eco.WinForm.ListAction.Add);
  Self.Button1.ImageIndex := 1;
  Self.Button1.Location := System.Drawing.Point.Create(416, 24);
  Self.Button1.Name := 'Button1';
  Self.EcoListActions.SetRootHandle(Self.Button1, Self.ehAllPersons);
  Self.Button1.TabIndex := 1;
  Self.Button1.Text := 'Add';
  // 
  // btnDeletePerson
  // 
  Self.btnDeletePerson.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnDeletePerson, Borland.Eco.WinForm.ListAction.Delete);
  Self.btnDeletePerson.ImageIndex := 2;
  Self.btnDeletePerson.Location := System.Drawing.Point.Create(416, 48);
  Self.btnDeletePerson.Name := 'btnDeletePerson';
  Self.EcoListActions.SetRootHandle(Self.btnDeletePerson, Self.ehAllPersons);
  Self.btnDeletePerson.TabIndex := 2;
  Self.btnDeletePerson.Text := 'Delete';
  // 
  // Button3
  // 
  Self.Button3.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.Button3, Borland.Eco.WinForm.ListAction.MoveFirst);
  Self.Button3.ImageIndex := 5;
  Self.Button3.Location := System.Drawing.Point.Create(288, 232);
  Self.Button3.Name := 'Button3';
  Self.EcoListActions.SetRootHandle(Self.Button3, Self.ehAllPersons);
  Self.Button3.Size := System.Drawing.Size.Create(25, 23);
  Self.Button3.TabIndex := 4;
  Self.Button3.Text := '|<';
  // 
  // Button4
  // 
  Self.Button4.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.Button4, Borland.Eco.WinForm.ListAction.MovePrev);
  Self.Button4.ImageIndex := 3;
  Self.Button4.Location := System.Drawing.Point.Create(320, 232);
  Self.Button4.Name := 'Button4';
  Self.EcoListActions.SetRootHandle(Self.Button4, Self.ehAllPersons);
  Self.Button4.Size := System.Drawing.Size.Create(25, 23);
  Self.Button4.TabIndex := 5;
  Self.Button4.Text := '<';
  // 
  // Button5
  // 
  Self.Button5.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.Button5, Borland.Eco.WinForm.ListAction.MoveNext);
  Self.Button5.ImageIndex := 4;
  Self.Button5.Location := System.Drawing.Point.Create(352, 232);
  Self.Button5.Name := 'Button5';
  Self.EcoListActions.SetRootHandle(Self.Button5, Self.ehAllPersons);
  Self.Button5.Size := System.Drawing.Size.Create(25, 23);
  Self.Button5.TabIndex := 6;
  Self.Button5.Text := '>';
  // 
  // Button6
  // 
  Self.Button6.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.Button6, Borland.Eco.WinForm.ListAction.MoveLast);
  Self.Button6.ImageIndex := 6;
  Self.Button6.Location := System.Drawing.Point.Create(384, 232);
  Self.Button6.Name := 'Button6';
  Self.EcoListActions.SetRootHandle(Self.Button6, Self.ehAllPersons);
  Self.Button6.Size := System.Drawing.Size.Create(25, 23);
  Self.Button6.TabIndex := 7;
  Self.Button6.Text := '>|';
  // 
  // btnNextBuilding
  // 
  Self.btnNextBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnNextBuilding, Borland.Eco.WinForm.ListAction.MoveNext);
  Self.btnNextBuilding.ImageIndex := 4;
  Self.btnNextBuilding.Location := System.Drawing.Point.Create(360, 192);
  Self.btnNextBuilding.Name := 'btnNextBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnNextBuilding, Self.cmAllBuildings);
  Self.btnNextBuilding.Size := System.Drawing.Size.Create(25, 23);
  Self.btnNextBuilding.TabIndex := 5;
  Self.btnNextBuilding.Text := '>';
  // 
  // cmAllBuildings
  // 
  Self.cmAllBuildings.BindingContext := Self.dgAllBuildings;
  Self.cmAllBuildings.RootHandle := Self.ehAllBuildings;
  // 
  // btnLastBuilding
  // 
  Self.btnLastBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnLastBuilding, Borland.Eco.WinForm.ListAction.MoveLast);
  Self.btnLastBuilding.ImageIndex := 6;
  Self.btnLastBuilding.Location := System.Drawing.Point.Create(392, 192);
  Self.btnLastBuilding.Name := 'btnLastBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnLastBuilding, Self.cmAllBuildings);
  Self.btnLastBuilding.Size := System.Drawing.Size.Create(25, 23);
  Self.btnLastBuilding.TabIndex := 6;
  Self.btnLastBuilding.Text := '>|';
  // 
  // btnAddBuilding
  // 
  Self.btnAddBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnAddBuilding, Borland.Eco.WinForm.ListAction.Add);
  Self.btnAddBuilding.ImageIndex := 1;
  Self.btnAddBuilding.Location := System.Drawing.Point.Create(432, 16);
  Self.btnAddBuilding.Name := 'btnAddBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnAddBuilding, Self.ehAllBuildings);
  Self.btnAddBuilding.TabIndex := 1;
  Self.btnAddBuilding.Text := 'Add';
  // 
  // btnDeleteBuilding
  // 
  Self.btnDeleteBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnDeleteBuilding, Borland.Eco.WinForm.ListAction.Delete);
  Self.btnDeleteBuilding.ImageIndex := 2;
  Self.btnDeleteBuilding.Location := System.Drawing.Point.Create(432, 40);
  Self.btnDeleteBuilding.Name := 'btnDeleteBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnDeleteBuilding, Self.cmAllBuildings);
  Self.btnDeleteBuilding.TabIndex := 2;
  Self.btnDeleteBuilding.Text := 'Delete';
  // 
  // btnFirstBuilding
  // 
  Self.btnFirstBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnFirstBuilding, Borland.Eco.WinForm.ListAction.MoveFirst);
  Self.btnFirstBuilding.ImageIndex := 5;
  Self.btnFirstBuilding.Location := System.Drawing.Point.Create(296, 192);
  Self.btnFirstBuilding.Name := 'btnFirstBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnFirstBuilding, Self.cmAllBuildings);
  Self.btnFirstBuilding.Size := System.Drawing.Size.Create(25, 23);
  Self.btnFirstBuilding.TabIndex := 3;
  Self.btnFirstBuilding.Text := '|<';
  // 
  // btnPrevBuilding
  // 
  Self.btnPrevBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetEcoListAction(Self.btnPrevBuilding, Borland.Eco.WinForm.ListAction.MovePrev);
  Self.btnPrevBuilding.ImageIndex := 3;
  Self.btnPrevBuilding.Location := System.Drawing.Point.Create(328, 192);
  Self.btnPrevBuilding.Name := 'btnPrevBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnPrevBuilding, Self.cmAllBuildings);
  Self.btnPrevBuilding.Size := System.Drawing.Size.Create(25, 23);
  Self.btnPrevBuilding.TabIndex := 4;
  Self.btnPrevBuilding.Text := '<';
  // 
  // Button13
  // 
  Self.Button13.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetBindingContext(Self.Button13, Self.lbxOwnedBuildings);
  Self.EcoListActions.SetEcoListAction(Self.Button13, Borland.Eco.WinForm.ListAction.Unlink);
  Self.Button13.ImageIndex := 7;
  Self.Button13.Location := System.Drawing.Point.Create(440, 144);
  Self.Button13.Name := 'Button13';
  Self.EcoListActions.SetRootHandle(Self.Button13, Self.ehOwnedbuildings);
  Self.Button13.TabIndex := 8;
  Self.Button13.Text := 'Unlink';
  // 
  // lbxOwnedBuildings
  // 
  Self.lbxOwnedBuildings.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.lbxOwnedBuildings.ContextMenu := Self.cmnOwnedBldg;
  Self.lbxOwnedBuildings.DataSource := Self.ehOwnedbuildings;
  Self.lbxOwnedBuildings.DisplayMember := 'address';
  Self.EcoModelAwareDragDrop.SetEcoDropTarget(Self.lbxOwnedBuildings, True);
  Self.lbxOwnedBuildings.Location := System.Drawing.Point.Create(520, 40);
  Self.lbxOwnedBuildings.Name := 'lbxOwnedBuildings';
  Self.lbxOwnedBuildings.Size := System.Drawing.Size.Create(136, 134);
  Self.lbxOwnedBuildings.TabIndex := 10;
  // 
  // cmnOwnedBldg
  // 
  Self.cmnOwnedBldg.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.MenuItem1));
  // 
  // MenuItem1
  // 
  Self.EcoListActions.SetBindingContext(Self.MenuItem1, Self.lbxOwnedBuildings);
  Self.EcoListActions.SetEcoListAction(Self.MenuItem1, Borland.Eco.WinForm.ListAction.Unlink);
  Self.MenuItem1.Index := 0;
  Self.EcoListActions.SetRootHandle(Self.MenuItem1, Self.ehOwnedbuildings);
  Self.MenuItem1.Text := 'Unlink';
  // 
  // ehOwnedbuildings
  // 
  Self.ehOwnedbuildings.Expression := 'self.ownedBuilding';
  Self.ehOwnedbuildings.RootHandle := Self.cmAllPersons;
  // 
  // cmAllPersons
  // 
  Self.cmAllPersons.BindingContext := Self.dgAllPersons;
  Self.cmAllPersons.RootHandle := Self.ehAllPersons;
  // 
  // btnUnlink
  // 
  Self.btnUnlink.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActions.SetBindingContext(Self.btnUnlink, Self.lbxOwners);
  Self.EcoListActions.SetEcoListAction(Self.btnUnlink, Borland.Eco.WinForm.ListAction.Unlink);
  Self.btnUnlink.ImageIndex := 7;
  Self.btnUnlink.Location := System.Drawing.Point.Create(432, 152);
  Self.btnUnlink.Name := 'btnUnlink';
  Self.EcoListActions.SetRootHandle(Self.btnUnlink, Self.ehOwners);
  Self.btnUnlink.TabIndex := 13;
  Self.btnUnlink.Text := 'Unlink';
  // 
  // lbxOwners
  // 
  Self.lbxOwners.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Right)));
  Self.lbxOwners.DataSource := Self.ehOwners;
  Self.lbxOwners.DisplayMember := 'fullName';
  Self.EcoModelAwareDragDrop.SetEcoDropTarget(Self.lbxOwners, True);
  Self.lbxOwners.Location := System.Drawing.Point.Create(520, 24);
  Self.lbxOwners.Name := 'lbxOwners';
  Self.lbxOwners.Size := System.Drawing.Size.Create(120, 186);
  Self.lbxOwners.TabIndex := 11;
  // 
  // ehOwners
  // 
  Self.ehOwners.Expression := 'self.owner';
  Self.ehOwners.RootHandle := Self.cmAllBuildings;
  // 
  // btnAddResidentialBuilding
  // 
  Self.btnAddResidentialBuilding.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.EcoListActions.SetEcoListAction(Self.btnAddResidentialBuilding, Borland.Eco.WinForm.ListAction.Add);
  Self.btnAddResidentialBuilding.ImageIndex := 1;
  Self.btnAddResidentialBuilding.Location := System.Drawing.Point.Create(144, 
      192);
  Self.btnAddResidentialBuilding.Name := 'btnAddResidentialBuilding';
  Self.EcoListActions.SetRootHandle(Self.btnAddResidentialBuilding, Self.ehResidentialBuildings);
  Self.btnAddResidentialBuilding.TabIndex := 5;
  Self.btnAddResidentialBuilding.Text := 'Add';
  // 
  // btnFirstRB
  // 
  Self.btnFirstRB.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.EcoListActions.SetEcoListAction(Self.btnFirstRB, Borland.Eco.WinForm.ListAction.MoveFirst);
  Self.btnFirstRB.ImageIndex := 5;
  Self.btnFirstRB.Location := System.Drawing.Point.Create(8, 192);
  Self.btnFirstRB.Name := 'btnFirstRB';
  Self.EcoListActions.SetRootHandle(Self.btnFirstRB, Self.ehResidentialBuildings);
  Self.btnFirstRB.Size := System.Drawing.Size.Create(25, 23);
  Self.btnFirstRB.TabIndex := 1;
  Self.btnFirstRB.Text := '|<';
  // 
  // btnPrevRB
  // 
  Self.btnPrevRB.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.EcoListActions.SetEcoListAction(Self.btnPrevRB, Borland.Eco.WinForm.ListAction.MovePrev);
  Self.btnPrevRB.ImageIndex := 3;
  Self.btnPrevRB.Location := System.Drawing.Point.Create(40, 192);
  Self.btnPrevRB.Name := 'btnPrevRB';
  Self.EcoListActions.SetRootHandle(Self.btnPrevRB, Self.ehResidentialBuildings);
  Self.btnPrevRB.Size := System.Drawing.Size.Create(25, 23);
  Self.btnPrevRB.TabIndex := 2;
  Self.btnPrevRB.Text := '<';
  // 
  // btnNextRB
  // 
  Self.btnNextRB.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.EcoListActions.SetEcoListAction(Self.btnNextRB, Borland.Eco.WinForm.ListAction.MoveNext);
  Self.btnNextRB.ImageIndex := 4;
  Self.btnNextRB.Location := System.Drawing.Point.Create(72, 192);
  Self.btnNextRB.Name := 'btnNextRB';
  Self.EcoListActions.SetRootHandle(Self.btnNextRB, Self.ehResidentialBuildings);
  Self.btnNextRB.Size := System.Drawing.Size.Create(25, 23);
  Self.btnNextRB.TabIndex := 3;
  Self.btnNextRB.Text := '>';
  // 
  // btnLastRB
  // 
  Self.btnLastRB.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.EcoListActions.SetEcoListAction(Self.btnLastRB, Borland.Eco.WinForm.ListAction.MoveLast);
  Self.btnLastRB.ImageIndex := 6;
  Self.btnLastRB.Location := System.Drawing.Point.Create(104, 192);
  Self.btnLastRB.Name := 'btnLastRB';
  Self.EcoListActions.SetRootHandle(Self.btnLastRB, Self.ehResidentialBuildings);
  Self.btnLastRB.Size := System.Drawing.Size.Create(25, 23);
  Self.btnLastRB.TabIndex := 4;
  Self.btnLastRB.Text := '>|';
  // 
  // MenuItem3
  // 
  Self.EcoListActions.SetActionExpression(Self.MenuItem3, 'self.PayRent');
  Self.EcoListActions.SetBindingContext(Self.MenuItem3, Self.dgAllPersons);
  Self.EcoListActions.SetEcoListAction(Self.MenuItem3, Borland.Eco.WinForm.ListAction.ExecuteAction);
  Self.MenuItem3.Index := 0;
  Self.EcoListActions.SetRootHandle(Self.MenuItem3, Self.ehAllPersons);
  Self.MenuItem3.Text := 'Pay Rent';
  // 
  // lbxResidents
  // 
  Self.lbxResidents.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Right)));
  Self.lbxResidents.DataSource := Self.ehResidents;
  Self.lbxResidents.DisplayMember := 'fullName';
  Self.EcoModelAwareDragDrop.SetEcoDropTarget(Self.lbxResidents, True);
  Self.lbxResidents.Location := System.Drawing.Point.Create(520, 24);
  Self.lbxResidents.Name := 'lbxResidents';
  Self.lbxResidents.Size := System.Drawing.Size.Create(128, 186);
  Self.lbxResidents.TabIndex := 8;
  // 
  // ehResidents
  // 
  Self.ehResidents.Expression := 'self.resident';
  Self.ehResidents.RootHandle := Self.cmResidentialBuildings;
  // 
  // cmResidentialBuildings
  // 
  Self.cmResidentialBuildings.BindingContext := Self.dgResidentialBuilding;
  Self.cmResidentialBuildings.RootHandle := Self.ehResidentialBuildings;
  // 
  // btnPayRent
  // 
  Self.btnPayRent.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnPayRent.Location := System.Drawing.Point.Create(416, 80);
  Self.btnPayRent.Name := 'btnPayRent';
  Self.btnPayRent.TabIndex := 3;
  Self.btnPayRent.Text := 'Pay Rent';
  Include(Self.btnPayRent.Click, Self.btnPayRent_Click);
  // 
  // btnAddRB
  // 
  Self.btnAddRB.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnAddRB.Location := System.Drawing.Point.Create(432, 80);
  Self.btnAddRB.Name := 'btnAddRB';
  Self.btnAddRB.TabIndex := 10;
  Self.btnAddRB.Text := 'Add RB';
  Include(Self.btnAddRB.Click, Self.btnAddRB_Click);
  // 
  // ehHome
  // 
  Self.ehHome.Expression := 'self.home';
  Self.ehHome.RootHandle := Self.cmAllPersons;
  // 
  // TextBox1
  // 
  Self.TextBox1.AllowDrop := True;
  Self.TextBox1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextBox1.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.cmAllPersons, 'home'));
  Self.TextBox1.Location := System.Drawing.Point.Create(552, 224);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.TabIndex := 13;
  Self.TextBox1.Text := 'TextBox1';
  Include(Self.TextBox1.DragOver, Self.TextBox1_DragOver);
  Include(Self.TextBox1.DragDrop, Self.TextBox1_DragDrop);
  Include(Self.TextBox1.DragEnter, Self.TextBox1_DragEnter);
  // 
  // Label1
  // 
  Self.Label1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label1.Location := System.Drawing.Point.Create(552, 208);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(100, 16);
  Self.Label1.TabIndex := 12;
  Self.Label1.Text := 'Home';
  // 
  // Label2
  // 
  Self.Label2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label2.Location := System.Drawing.Point.Create(512, 16);
  Self.Label2.Name := 'Label2';
  Self.Label2.TabIndex := 9;
  Self.Label2.Text := 'Owned buildings';
  // 
  // GroupBox1
  // 
  Self.GroupBox1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.GroupBox1.Controls.Add(Self.TabControl1);
  Self.GroupBox1.Location := System.Drawing.Point.Create(120, 280);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(664, 272);
  Self.GroupBox1.TabIndex := 0;
  Self.GroupBox1.TabStop := False;
  Self.GroupBox1.Text := 'Buildings';
  // 
  // TabControl1
  // 
  Self.TabControl1.Controls.Add(Self.TabPage1);
  Self.TabControl1.Controls.Add(Self.TabPage2);
  Self.TabControl1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.TabControl1.Location := System.Drawing.Point.Create(3, 16);
  Self.TabControl1.Name := 'TabControl1';
  Self.TabControl1.SelectedIndex := 0;
  Self.TabControl1.Size := System.Drawing.Size.Create(658, 253);
  Self.TabControl1.TabIndex := 0;
  // 
  // TabPage1
  // 
  Self.TabPage1.Controls.Add(Self.dgAllBuildings);
  Self.TabPage1.Controls.Add(Self.lbxOwners);
  Self.TabPage1.Controls.Add(Self.btnDeleteBuilding);
  Self.TabPage1.Controls.Add(Self.Label3);
  Self.TabPage1.Controls.Add(Self.btnAddBuilding);
  Self.TabPage1.Controls.Add(Self.btnAddRB);
  Self.TabPage1.Controls.Add(Self.btnUnlink);
  Self.TabPage1.Controls.Add(Self.btnFirstBuilding);
  Self.TabPage1.Controls.Add(Self.btnPrevBuilding);
  Self.TabPage1.Controls.Add(Self.btnLastBuilding);
  Self.TabPage1.Controls.Add(Self.btnNextBuilding);
  Self.TabPage1.Location := System.Drawing.Point.Create(4, 22);
  Self.TabPage1.Name := 'TabPage1';
  Self.TabPage1.Size := System.Drawing.Size.Create(650, 227);
  Self.TabPage1.TabIndex := 0;
  Self.TabPage1.Text := 'Buildings';
  // 
  // Label3
  // 
  Self.Label3.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label3.Location := System.Drawing.Point.Create(520, 8);
  Self.Label3.Name := 'Label3';
  Self.Label3.TabIndex := 12;
  Self.Label3.Text := 'Owners';
  // 
  // TabPage2
  // 
  Self.TabPage2.Controls.Add(Self.btnChargeRent);
  Self.TabPage2.Controls.Add(Self.lbxResidents);
  Self.TabPage2.Controls.Add(Self.Label4);
  Self.TabPage2.Controls.Add(Self.btnAddResidentialBuilding);
  Self.TabPage2.Controls.Add(Self.dgResidentialBuilding);
  Self.TabPage2.Controls.Add(Self.btnFirstRB);
  Self.TabPage2.Controls.Add(Self.btnPrevRB);
  Self.TabPage2.Controls.Add(Self.btnNextRB);
  Self.TabPage2.Controls.Add(Self.btnLastRB);
  Self.TabPage2.Location := System.Drawing.Point.Create(4, 22);
  Self.TabPage2.Name := 'TabPage2';
  Self.TabPage2.Size := System.Drawing.Size.Create(650, 227);
  Self.TabPage2.TabIndex := 1;
  Self.TabPage2.Text := 'Residential buildings';
  // 
  // btnChargeRent
  // 
  Self.btnChargeRent.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.btnChargeRent.Location := System.Drawing.Point.Create(288, 192);
  Self.btnChargeRent.Name := 'btnChargeRent';
  Self.btnChargeRent.Size := System.Drawing.Size.Create(88, 23);
  Self.btnChargeRent.TabIndex := 6;
  Self.btnChargeRent.Text := 'Charge Rent';
  Include(Self.btnChargeRent.Click, Self.Button25_Click);
  // 
  // Label4
  // 
  Self.Label4.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label4.Location := System.Drawing.Point.Create(520, 8);
  Self.Label4.Name := 'Label4';
  Self.Label4.TabIndex := 7;
  Self.Label4.Text := 'Residents';
  // 
  // GroupBox2
  // 
  Self.GroupBox2.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.GroupBox2.Controls.Add(Self.btnLeave);
  Self.GroupBox2.Controls.Add(Self.Button13);
  Self.GroupBox2.Controls.Add(Self.Button1);
  Self.GroupBox2.Controls.Add(Self.btnDeletePerson);
  Self.GroupBox2.Controls.Add(Self.Button3);
  Self.GroupBox2.Controls.Add(Self.Button4);
  Self.GroupBox2.Controls.Add(Self.btnPayRent);
  Self.GroupBox2.Controls.Add(Self.TextBox1);
  Self.GroupBox2.Controls.Add(Self.Label1);
  Self.GroupBox2.Controls.Add(Self.Button6);
  Self.GroupBox2.Controls.Add(Self.Button5);
  Self.GroupBox2.Controls.Add(Self.dgAllPersons);
  Self.GroupBox2.Controls.Add(Self.lbxOwnedBuildings);
  Self.GroupBox2.Controls.Add(Self.Label2);
  Self.GroupBox2.Location := System.Drawing.Point.Create(120, 8);
  Self.GroupBox2.Name := 'GroupBox2';
  Self.GroupBox2.Size := System.Drawing.Size.Create(664, 264);
  Self.GroupBox2.TabIndex := 0;
  Self.GroupBox2.TabStop := False;
  Self.GroupBox2.Text := 'Persons';
  // 
  // btnLeave
  // 
  Self.btnLeave.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnLeave.Location := System.Drawing.Point.Create(472, 224);
  Self.btnLeave.Name := 'btnLeave';
  Self.btnLeave.TabIndex := 11;
  Self.btnLeave.Text := 'Move out';
  Include(Self.btnLeave.Click, Self.btnLeave_Click);
  // 
  // GroupBox3
  // 
  Self.GroupBox3.Controls.Add(Self.btnRedo);
  Self.GroupBox3.Controls.Add(Self.btnUndo);
  Self.GroupBox3.Controls.Add(Self.btnCheckpoint);
  Self.GroupBox3.Controls.Add(Self.btnCreateSchema);
  Self.GroupBox3.Controls.Add(Self.btnUpdateDB);
  Self.GroupBox3.Controls.Add(Self.btnActivate);
  Self.GroupBox3.Dock := System.Windows.Forms.DockStyle.Left;
  Self.GroupBox3.Location := System.Drawing.Point.Create(0, 0);
  Self.GroupBox3.Name := 'GroupBox3';
  Self.GroupBox3.Size := System.Drawing.Size.Create(112, 557);
  Self.GroupBox3.TabIndex := 21;
  Self.GroupBox3.TabStop := False;
  Self.GroupBox3.Text := 'System';
  // 
  // cmnPerson
  // 
  Self.cmnPerson.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.MenuItem3));
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(808, 557);
  Self.Controls.Add(Self.GroupBox3);
  Self.Controls.Add(Self.GroupBox1);
  Self.Controls.Add(Self.GroupBox2);
  Self.MinimumSize := System.Drawing.Size.Create(616, 544);
  Self.Name := 'TWinForm';
  Self.Text := 'Buildings and Owners';
  (System.ComponentModel.ISupportInitialize(Self.dgAllBuildings)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgAllPersons)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgResidentialBuilding)).EndInit;
  Self.GroupBox1.ResumeLayout(False);
  Self.TabControl1.ResumeLayout(False);
  Self.TabPage1.ResumeLayout(False);
  Self.TabPage2.ResumeLayout(False);
  Self.GroupBox2.ResumeLayout(False);
  Self.GroupBox3.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;

  FEcoSpace := TBldOwnEcoSpace.Create;
  rhRoot.EcoSpace := FEcoSpace;
  // The line below will automatically activate the ECO Space.
  // Remove the line if you wish to activate it manually
  //FEcoSpace.Active := true;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;


function TWinForm.GetDraggedObject(e: System.Windows.Forms.DragEventArgs): IObject;
begin
  Result := EcoWinFormHelper.GetDroppedElement(e) as IObject;
end;

end.



